<?php
function handleQdResponse($data, $encode = true, $encrypt = true)
{
		header('Content-Type: application/json');
    if ($encrypt) {
        if ($encode) {
            $toSend = json_encode($data);
        } else {
            $toSend = $data;
        }
        $response = ['status' => true, 'encrypted' => true, 'data' => qdEncrypt($toSend), 'message' => 'OK'];
        echo json_encode($response);
        exit;
    } else {
        $response = ['status' => true, 'data' => $data, 'message' => 'OK'];
        echo json_encode($response);
        exit;
    }
}
ini_set('memory_limit', -1);
include("../includes/functions.php");
error_reporting(0);
ini_set('display_errors', 0);
$key = "YwSUrhDEZQMOBdybgCFLCxAesprrOBBq";
$iv = "3455502825992902";
$epgCaching = true;
$bearer = getBearerToken();
if ($bearer) {
    parse_str(base64_decode($bearer), $inParams);
    $appId = qdDecrypt($inParams['username']);
    $username = qdDecrypt($inParams['username']);
    $password = qdDecrypt($inParams['password']);
    $portal = qdDecrypt($inParams['service']);
}

$urlParts = explode('/', $_GET['path']);
switch ($urlParts[0]) {
    case "app-configs":
        $appId = $_GET['app_id'];
        $row = loadLTQDOptions();
        handleQdResponse($row);
        break;
    case "auth":
        $rawData = file_get_contents('php://input');
        //echo $rawData;
        parse_str($rawData, $output);

        $app_id = qdDecrypt(urldecode($output['app_id']));
        $app_id = qdDecrypt(urldecode($output['app_id']));
        $username = qdDecrypt(urldecode($output['username']));
        $password = qdDecrypt(urldecode($output['password']));

        if ($username == '') {
            $username = qdDecrypt($output['username']);
        }

        if ($password == '') {
            $password = qdDecrypt($output['password']);
        }
        $dnsInfo = loadAllDNS(true);
        foreach ($dnsInfo as $thisDns) {
            //echo $thisDns['portal'] . '/player_api.php?username=' . $username . '&password=' . $password;
            $response = callApi($thisDns['portal'] . '/player_api.php?username=' . $username . '&password=' . $password);
            $data = json_decode($response['data'], true);
            if ($data) {
                if (isset($data['user_info']['auth'])) {
                    if ($data['user_info']['auth'] != 0) {
                        if ($data['user_info']['status'] == 'Active') {
                            $token = base64_encode($rawData . '&service=' . urlencode(qdEncrypt($thisDns['portal'])));
                            $userInfo = $data['user_info'];
                            $serverinfo = $data['server_info'];
							if(!$serverinfo['port'])
							{
								$serverinfo['port'] = 80;
							}
							if(!$serverinfo['https_port'])
							{
								$serverinfo['https_port'] = 443;
							}
                            $returnable = ['access_token' => $token, 'token_type' => 'Bearer', 'expires_at' => '2050-01-01 00:00:00', 'status' => true, 'user' => $userInfo, 'server' => $serverinfo];
                            
							handleQdResponse($returnable);
                        }
                    }
                }
            }
        }
        break;
    case "stream-categories":
        $type = $_GET['type'];
        if ($type == 'movie') {
            $action = 'get_vod_categories';
        }
        if ($type == 'series') {
            $action = 'get_series_categories';
        }
        if ($type == 'live') {
            $action = 'get_live_categories';
        }
        $url = $portal . '/player_api.php?username=' . $username . '&password=' . $password . '&action=' . $action . '';
        $response = callApi($url);
        $data = json_decode($response['data'], true);

        $transformed = array_map(function ($obj, $index) use ($type) {
            return ['id' => $obj['category_id'], 'category_type' => $type, 'category_name' => $obj['category_name'], 'parent_id' => $obj['parent_id'], 'cat_order' => $index + 1];
        }, $data, array_keys($data));
        handleQdResponse($transformed);
        break;
    case "profile":
        $response = callApi($portal . '/player_api.php?username=' . $username . '&password=' . $password);
        $data = json_decode($response['data'], true);
        $user = $data['user_info'];
        $server = $data['server_info'];
		if(! $server['port'])
		{
			$server['port'] = 80;
		}
		if(!$server['https_port'])
		{
			$server['https_port'] = 443;
		}
        $result = ['user' => $user, 'server' => $server];
        handleQdResponse($result);
        break;
    case "movies":
        $response = callApi($portal . '/player_api.php?username=' . $username . '&password=' . $password . '&action=get_vod_info&vod_id=' . $urlParts[2]);
        $data = json_decode($response['data'], true);
        handleQdResponse($data);
        break;
    case "catalogues";
        $appId = $_GET['app_id'];
        $catalogues = [];
        $allApps = loadLTQDAppstore();
        foreach ($allApps as $row) {
            $data = ['id' => $row['id'], 'name' => $row['name'], 'package_name' => $row['package_name'], 'install_url' => $row['install_url'], 'description' => $row['description'], 'banner' => $row['banner'], 'created_at' => $row['created_at'], 'updated_at' => $row['updated_at'], 'app_id' => $row['app_id']];
            array_push($catalogues, $data);
        }
        handleQdResponse($catalogues);
        break;
        case "apps";
        $appId = $urlParts[1];
        
        $row = loadLTQDAppstoreApp($appId );
        
            $data = ['id' => $row['id'], 'name' => $row['name'], 'package_name' => $row['package_name'], 'install_url' => $row['install_url'], 'description' => $row['description'], 'banner' => $row['banner'], 'created_at' => $row['created_at'], 'updated_at' => $row['updated_at'], 'app_id' => $row['app_id']];
       
        handleQdResponse($row);
        break;
    case "players":
        handleQdResponse([]);
        break;
    case 'series':
        switch ($urlParts[1]) {
            case 'info';
                $response = callApi($portal . '/player_api.php?username=' . $username . '&password=' . $password . '&action=get_series_info&series_id=' . $urlParts[2]);
                $data = $response['data'];
                $decoded = json_decode($data, true);

                if (count($decoded['seasons'])) {
                    $decoded['info']['seasons_count'] = count($decoded['seasons']);
                } else {
                    $decoded['info']['seasons_count'] = 1;
                }
                $nxt = false;
                if ($nxt) {
                    $decoded['info']['seasons_count'] = count($decoded['episodes']);
                }
                handleQdResponse($decoded['info']);
                exit;
                break;
            case "seasons":
                $response = callApi($portal . '/player_api.php?username=' . $username . '&password=' . $password . '&action=get_series_info&series_id=' . $urlParts[2]);
                $data = $response['data'];
                $decoded = json_decode($data, true);
                if (count($decoded['seasons']) && isset($decoded['seasons'][0]['id'])) {
                    $seasons = json_encode($decoded['seasons']);
                    $seasons = preg_replace('/"episode_run_time":""/', '"episode_run_time":"1"', $seasons);
                    $seasons = preg_replace('/"id":""/', '"id":"1"', $seasons);
                    $seasons = json_decode($seasons);
                } else {
                    $seasons = array();
                    foreach ($decoded['episodes'] as $arrayKey => $value) {
                        $episodeCount = count($value);
                        if ($episodeCount > 0) {
                            $releasedate = $value[0]['info']['release_date'];
                            $coverUrl = $decoded['info']['cover'];
                        }
                        $releasedate = '2021-01-01';
                        $dummySeason = '{
                        "id": ' . $arrayKey . ',
                        "name": "Season ' . $arrayKey . '",
                        "episode_count": "' . $episodeCount . '",
                        "overview": "' . $coverUrl . '",
                        "air_date": "' . $releasedate . '",
                        "cover": "' . $coverUrl . '",
                        "season_number": ' . $arrayKey . ',
                        "cover_big": "' . $coverUrl . '"}';
                        $seasons[] = json_decode($dummySeason);
                    }
                }
                handleQdResponse($seasons);
                break;
            case "episodes":
                $response = callApi($portal . '/player_api.php?username=' . $username . '&password=' . $password . '&action=get_series_info&series_id=' . $urlParts[2]);
                $data = json_decode($response['data'], true);
                $season = false;
                foreach ($data['seasons'] as $s) {
                    if ($s['id'] == $urlParts[3]) {
                        $season = $s;
                        break;
                    }
                }
                $episodeList = array();
                foreach ($data['episodes'] as $allEpisodes) {
                    foreach ($allEpisodes as $episode) {
                        if ($season['season_number'] == $episode['season'] || $episode['season'] == $urlParts[3]) {
                            $episodeList[] = $episode;
                        }
                    }
                }
                $response = [
                    'season'       => $season,
                    'episodes'     => $episodeList,
                    'userWatching' => []
                ];
                handleQdResponse($response);
                break;
        }
        break;
    case "xmltv":
	header("Content-type: text/xml");
	  $provider = md5($portal);
        $filename = "epg-cache/" . $provider;
        if ($epgCaching && file_exists($filename) && filemtime($filename) > time() - (2 * 60 * 60)) {
            $xml = file_get_contents($filename);
        } else {
			$url =  $portal . '/xmltv.php?username=' . $username . '&password=' . $password;
		            $response = callApi($url);
		if(isset($response['headers']['cache_id']))
		{
			$fullFileName = "epg-cache/full_" . $provider . $response['headers']['cache_id'];
		}
		else{
			$fullFileName = "epg-cache/full_" . $provider;
		}
		file_put_contents($fullFileName, $response['data']);
		$xmlObject = new XMLReader();
		$xmlObject->XML($response['data']);
		$startCutOff = time()-(2*60*60);
		$endCutOff = time()+(24*60*60);
		$programmes = "";
		$channels = "";
		while($xmlObject->read())
		{
			if($xmlObject->name == 'programme'){
				
				$stopTime = strtotime($xmlObject->getAttribute('stop'));
				if( $stopTime< $startCutOff || $stopTime > $endCutOff)
				{
				}
				else{
					$count++;
					if($xmlObject->readInnerXML())
					{
						$programmes .= $xmlObject->readOuterXML();
					}
				}
			}
		}
		$xml = '<?xml version="1.0" encoding="utf-8" ?><!DOCTYPE tv SYSTEM "xmltv.dtd">
		<tv generator-info-name="OnePanel">
		';
		$xml .= $channels . '
		';
		$xml .= $programmes . '
		';
		$xml .= '</tv>';
		libxml_use_internal_errors(true);

		$validXml = true;
		$doc = simplexml_load_string($xml);
		if (!$doc) {
			$errorStr = "";
			$errors = libxml_get_errors();
			  foreach ($errors as $error) {
				$errorStr .= $error . ", ";
			}
			file_put_contents("epg-cache/errors/" . time() . "_error",$errorStr);
			libxml_clear_errors();
		}
            if ($epgCaching && strlen($xml) > 1000) {
                file_put_contents($filename, $xml);
            }
        }
		
        echo $xml;
        exit;
        break;
    case "streams":
        if (!isset($urlParts[1])) {
            $type = $_GET['type'];
            if ($type == 'live') {
                $action = 'get_live_streams';
            }

            if ($type == 'movie') {
                $action = 'get_vod_streams';
            }

            if ($type == 'series') {
                $action = 'get_series';
            }
            $response = callApi($portal . '/player_api.php?username=' . $username . '&password=' . $password . '&action=' . $action . '');
            $data = json_decode($response['data'], true);
			 if ($type == 'series') {
              
            
			$toSend = array();
			foreach($data as $stream)
			{
				if(!$stream['tmdb'])
				{
					$stream['tmdb'] = 0;
				}
				if(!$stream['rating'])
				{
					$stream['rating'] = 0;
				}
				if(!$stream['rating_5based'])
				{
					$stream['rating_5based'] = 0;
				}
				if(!$stream['episode_run_time'])
				{
					$stream['episode_run_time'] = 30;
				}
				if(!$stream['num'])
				{
					$stream['num'] = 1;
				}
				if(!$stream['last_modified'])
				{
					$stream['last_modified'] = 1;
				}
				if(!$stream['series_id'])
				{
					$stream['series_id'] = 1;
				}
				if(!$stream['releaseDate'])
				{
					$stream['releaseDate'] = 1;
				}
				if(!$stream['category_id'])
				{
					$stream['category_id'] = 1;
				}
				$toSend[] = $stream;
			}
            handleQdResponse($toSend); 
			 }
			 else
			 {
				handleQdResponse($data); 
			 }
        } else if ($urlParts[1] == "catchups") {
            $response = callApi($portal . '/player_api.php?username=' . $username . '&password=' . $password . '&action=get_simple_data_table&stream_id=' . $urlParts[2]);
            $data = json_decode($response['data'], true);
            $dates = [];
            foreach ($data['epg_listings'] as $epg) {
                if (preg_match('/^[a-zA-Z0-9\\/\\r\\n+]*={0,2}$/', $epg['title'])) {
                    $epg['title'] = base64_decode($epg['title']);
                }
                if (preg_match('/^[a-zA-Z0-9\\/\\r\\n+]*={0,2}$/', $epg['description'])) {
                    $epg['description'] = base64_decode($epg['description']);
                }
                //$epg['start_timestamp']=$epg['start'];
                $epg['end_timestamp'] = $epg['stop_timestamp'];
                $date_string = $epg['start'];
                $date_object = new DateTime($date_string);
                $formatted_date = $date_object->format('Ymd');

                if (!isset($dates[$formatted_date])) {
                    $dates[$formatted_date] = [];
                }

                array_push($dates[$formatted_date], $epg);
            }
            //echo json_encode($dates);exit;
            handleQdResponse($dates);
        }
        break;
    case "themes":

        $data = [];
        $allThemes = loadLTQDThemes();
        foreach ($allThemes as $row) {
            array_push($data, ['id' => $row['id'], 'name' => $row['name'], 'preview_image' => $row['preview_image'], 'created_at' => $row['created_at'], 'updated_at' => $row['updated_at'], 'download_url' => $row['download_url']]);
        }
        handleQdResponse($data, false, false);
        break;
    case "sections":
        if ($urlParts[1]) {

            $allSectionItems = loadLTQDSectionItems($urlParts[1]);
            $data = [];
            foreach ($allSectionItems as $row) {
                array_push($data, $row);
            }
            handleQdResponse($data);
        } else {
            $allSections = loadLTQDSections();
            $data = [];
            foreach ($allSections as $row) {
                array_push($data, ['id' => $row['id'], 'title' => $row['title'], 'enabled' => $row['enabled'], 'predefined' => $row['predefined'], 'reference' => $row['reference']]);
            }
			//var_dump($data);
            handleQdResponse($data);
        }
        break;
    case "event-categories":
        if ($urlParts[1] == "schedule-dates") {
            $allSportsEvents = loadLTQDSportsEvents($urlParts[2]);
            $data = [];

            foreach ($allSportsEvents as $row) {
                $datetime = new DateTime($row['start_timestamp']);
                $datetime->setTimezone(new DateTimeZone('UTC'));
                array_push($data, $datetime->format('Y-m-d 06:00:00'));
            }
            $data = array_unique($data);
			            $data = array_slice($data,0,5);

            handleQdResponse($data);

        } else  if ($urlParts[1] == "getByDate") {
            $allSportsEvents = loadLTQDSportsEvents($_POST['category_id']);
            $data = [];

            foreach ($allSportsEvents as $row) {
                if ((strtotime($_POST['date']) <= strtotime($row['start_timestamp'])) && (strtotime($row['start_timestamp']) <= strtotime($_POST['date']) + 86400)) {
                    $team_a = loadLTQDSportsTeam($row['team_a_id']);
                    $team_b = loadLTQDSportsTeam($row['team_b_id']);
                    $channel_id_array = array_filter(array_map('intval', getEventStreamIDs($portal, $row['id'])));
                    array_push($data, [
                        'id'              => $row['id'],
                        'team_a_id'       => $row['team_a_id'],
                        'team_b_id'       => $row['team_b_id'],
                        'backdrop'        => $row['backdrop'],
                        'start_timestamp' => $row['start_timestamp'],
                        'end_timestamp'   => $row['end_timestamp'],
                        'description'     => $row['description'],
                        'created_at'      => $row['created_at'],
                        'updated_at'      => $row['updated_at'],
                        'category_id'     => !empty($row['category_id']) ? $row['category_id'] : 0,
                        'channel_id'      => $channel_id_array,
                        'team_a'          => ['id' => $team_a['id'], 'name' => $team_a['name'], 'flag' => $team_a['flag'], 'created_at' => $team_a['created_at'], 'updated_at' => $team_a['updated_at']],
                        'team_b'          => ['id' => $team_b['id'], 'name' => $team_b['name'], 'flag' => $team_b['flag'], 'created_at' => $team_b['created_at'], 'updated_at' => $team_b['updated_at']]
                    ]);
                }
            }
            handleQdResponse($data);
        } else {
            $allCategories = loadLTQDSportsCategories();
            $data = [];
            foreach ($allCategories as $row) {
                array_push($data, $row);
            }
            handleQdResponse($data);
            break;
        }
        break;
    case "sports-events":
        if ($urlParts[1] == 'get') {
            $allSportsEvents = loadLTQDSportsEvents();
            $data = [];
            foreach ($allSportsEvents as $row) {
                if ((strtotime($urlParts[2]) <= strtotime($row['start_timestamp'])) && (strtotime($row['start_timestamp']) <= strtotime($urlParts[2]) + 86400)) {
                    $team_a = loadLTQDSportsTeam($row['team_a_id']);
                    $team_b = loadLTQDSportsTeam($row['team_b_id']);
                    $channel_id_array = array_filter(array_map('intval', getEventStreamIDs($portal, $row['id'])));
                    array_push($data, [
                        'id'              => $row['id'],
                        'team_a_id'       => $row['team_a_id'],
                        'team_b_id'       => $row['team_b_id'],
                        'backdrop'        => $row['backdrop'],
                        'start_timestamp' => $row['start_timestamp'],
                        'end_timestamp'   => $row['end_timestamp'],
                        'description'     => $row['description'],
                        'created_at'      => $row['created_at'],
                        'updated_at'      => $row['updated_at'],
                        'category_id'     => !empty($row['category_id']) ? $row['category_id'] : 0,
                        'channel_id'      => $channel_id_array,
                        'team_a'          => ['id' => $team_a['id'], 'name' => $team_a['name'], 'flag' => $team_a['flag'], 'created_at' => $team_a['created_at'], 'updated_at' => $team_a['updated_at']],
                        'team_b'          => ['id' => $team_b['id'], 'name' => $team_b['name'], 'flag' => $team_b['flag'], 'created_at' => $team_b['created_at'], 'updated_at' => $team_b['updated_at']]
                    ]);
                }
            }
            handleQdResponse($data);
        } else if ($urlParts[1] == 'schedule-dates') {
            $allSportsEvents = loadLTQDSportsEvents();
            $data = [];
            foreach ($allSportsEvents as $row) {
                $datetime = new DateTime($row['start_timestamp']);
                $datetime->setTimezone(new DateTimeZone('UTC'));
                array_push($data, $datetime->format('Y-m-d 06:00:00'));
            }
            $data = array_unique($data);
            $data = array_slice($data,0,5);
            handleQdResponse($data);
        }
        break;
   case "messages":
    $row = loadLTQDOptions();
        if ($urlParts[1] == 'send') {
            $reportData = $_POST['data'];
            $decrypted = qdDecrypt($reportData);
            $message=[
                'id'              => 2,
                'conversation_id'       => 1,
                'created_at'       => time()*1000,
                'is_read'        => false,
                'message' => $decrypted,
                'sender'   => 'User'
            ];
			if($row['chat_client_id'])
			{
				pushChatNotification($username,$decrypted);
			}
			$allMessages = loadLTQDMessages($username);
			$lastMessageTime = 0;
			foreach($allMessages as $thisMessage)
			{
				$lastMessageTime = $thisMessage['message_datetime'];
			}
			
            addLTQDMessage($username,$decrypted,0);
			if($lastMessageTime < (time()-(5*60)))
			{
				if($row['message_autorespond'])
				{
					addLTQDMessage($username,$row['message_autorespond'],1);
				}
			}
			
            handleQdResponse($message);
        }
		 if ($urlParts[1] == 'push') {
            $key = base64_decode($_POST['key']);
			if($key == $sportsApiKey)
			{
				$username = base64_decode($_POST['user']);
				$message = base64_decode($_POST['message']);
				addLTQDMessage($username,$message,1);
				echo "ok";
				exit;
			}
        }
        $messages = array();
        $allMessages = loadLTQDMessages($username);
        foreach($allMessages as $thisMessage)
        {
            $message = [
                'id'              => $thisMessage['id'],
                'conversation_id'       => 1,
                'created_at'       => $thisMessage['message_datetime']*1000,
                'is_read'        => false,
                'message' => ($thisMessage['message_outbound'] == 1 ?  $row['message_from'] : "You") . ": " . $thisMessage['message_text'],
                'sender'   => $thisMessage['message_outbound'] == 1 ? "Reseller" : "User"
            ];
            $messages[] =  $message;
        }
        handleQdResponse($messages);
        break;
    case "report":
        $reportData = $_POST['data'];
        $report = json_decode(qdDecrypt($reportData), true);
        addChannelReport($portal, $username, $report['message'], $report['stream_id'], $report['type']);
        break;
}