<?php

$dbFile = dirname(__file__) . "/db.php";
include($dbFile);
function login($username, $password)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM users WHERE username = ?");
	$query->bind_param("s", $username);
	$query->execute();
	$result = $query->get_result();
	if ($result->num_rows > 0) {
		$array = $result->fetch_array();
		if (password_verify($password, $array['password_hash'])) {
			return true;
		} else {
			return false;
		}
	} else {
		return false;
	}
}
function addUser($username, $password)
{
	global $mysqli;;

	$passwordHash = password_hash($password, PASSWORD_DEFAULT);
	$query = $mysqli->prepare("INSERT INTO users (username, password_hash) VALUES (?,?);");
	$query->bind_param("ss", $username, $passwordHash);
	$query->execute();
	return true;
}
function checkRewrites()
{
	$results = array();
	if (function_exists('apache_get_modules')) {
		$modules = apache_get_modules();

		if (!in_array("mod_rewrite", $modules)) {
			$results[] = "Apache module mod_rewrite is not loaded.";
		}
	} else {
		$results[] = "OnePanel doesn't seem to be running on an Apache Server, you may need to manually manage the rewrites";
	}
	$baseUrl = $GLOBALS['panelroot'];

	$smartersTestUrl = $baseUrl . "smarters/index";
	if (file_get_contents($smartersTestUrl) != "ok") {
		$results[] = "/smarters/.htaccess is not being processed properly";
	}
	$forwardTestUrl = $baseUrl . "forward/httest/testhtaccess";
	if (file_get_contents($forwardTestUrl) != "ok") {
		$results[] = "/forward/.htaccess is not being processed properly";
	}
	$proxyTestUrl = $baseUrl . "proxy/httest/testhtaccess";
	if (file_get_contents($proxyTestUrl) != "ok") {
		$results[] = "/proxy/.htaccess is not being processed properly";
	}
	return $results;
}

function callApi($api_link, $headersOnly = false, $useragent = false)
{

	$ch = curl_init();
	if ($useragent) {
		$config['useragent'] = $useragent;
	} else {
		$config['useragent'] = 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0';
	}

	curl_setopt($ch, CURLOPT_USERAGENT, $config['useragent']);
	curl_setopt($ch, CURLOPT_URL, $api_link);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, !$headersOnly);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, 60);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_HEADER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	$response = curl_exec($ch);
	$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
	$header = substr($response, 0, $header_size);
	$html = substr($response, $header_size);

	$headers = get_headers_from_curl_response($header);

	return ["result" => "success", "data" => $html, "headers" => $headers];
}

function get_headers_from_curl_response($headerRaw)
{
	$headers = array();

	foreach (explode("\r\n", $headerRaw) as $i => $line)
		if ($i === 0)
			$headers['http_code'] = $line;
		else {
			list($key, $value) = explode(': ', $line);

			$headers[$key] = $value;
		}

	return $headers;
}

function saveFemtoOptions($showLive, $showSeries, $showVOD, $showEPG, $showContentUpdate, $proxyTraffic)
{
	global $mysqli;
	$showLiveInt = 1;
	$showSeriesInt = 1;
	$showVODInt = 1;
	$showEPGInt = 1;
	$showContentUpdateInt = 1;

	if ($showLive == false) {
		$showLiveInt = 0;
	}
	if ($showSeries == false) {
		$showSeriesInt = 0;
	}
	if ($showVOD == false) {
		$showVODInt = 0;
	}
	if ($showEPG == false) {
		$showEPGInt = 0;
	}
	if ($showContentUpdate == false) {
		$showContentUpdateInt = 0;
	}
	$query = $mysqli->prepare("UPDATE femto_options SET show_live=?, show_series=?, show_vod=?, show_epg=?, show_content_update=?, proxy_traffic=?");
	$query->bind_param("iiiiii", $showLiveInt, $showSeriesInt, $showVODInt, $showEPGInt, $showContentUpdateInt, $proxyTraffic);
	$query->execute();
}
function loadFemtoOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM femto_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['showLive'] = $resultArray['show_live'];
	$returnable['showSeries'] = $resultArray['show_series'];
	$returnable['showVOD'] = $resultArray['show_vod'];
	$returnable['showEPG'] = $resultArray['show_epg'];
	$returnable['showContentUpdate'] = $resultArray['show_content_update'];
	$returnable['proxyTraffic'] = $resultArray['proxy_traffic'];
	return $returnable;
}

function saveSmartersOptions($proxyTraffic)
{
	global $mysqli;

	$query = $mysqli->prepare("UPDATE smarters_options SET proxy_traffic=?");
	$query->bind_param("i", $proxyTraffic);
	$query->execute();
}
function loadSmartersOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM smarters_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['proxyTraffic'] = $resultArray['proxy_traffic'];
	return $returnable;
}

function saveImPlayerOptions($proxyTraffic)
{
	global $mysqli;


	$query = $mysqli->prepare("UPDATE implayer_options SET proxy_traffic=?");
	$query->bind_param("i", $proxyTraffic);
	$query->execute();
}
function loadImPlayerOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM implayer_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['proxyTraffic'] = $resultArray['proxy_traffic'];
	return $returnable;
}
//loadOptions
function saveLTQOptions($proxyTraffic)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE ltq_options SET proxy_traffic=?");
	$query->bind_param("i", $proxyTraffic);
	$query->execute();
}
function loadLTQOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltq_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['proxyTraffic'] = $resultArray['proxy_traffic'];
	return $returnable;
}
function saveTiviOptions($proxyTraffic)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE tivimate_options SET proxy_traffic=?");
	$query->bind_param("i", $proxyTraffic);
	$query->execute();
}
function loadTiviOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM tivimate_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['proxyTraffic'] = $resultArray['proxy_traffic'];
	return $returnable;
}
function savePanelRoot($rootPath)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE config SET panel_root=?");
	$query->bind_param("s", $rootPath);
	$query->execute();
}
function loadPanelRoot()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM config");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	return $resultArray['panel_root'];
}
function addDNS($name, $url,  $username, $password)
{
	global $mysqli;
	$query = $mysqli->prepare("INSERT INTO dns (name, url, username, password, active) VALUES (?,?,?,?,1);");
	$query->bind_param("ssss", $name, $url, $username, $password);
	$query->execute();
}
function deleteDNS($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM dns WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
	clearDNSSessions();
}
function saveDNS($id, $name, $url, $username, $password, $active)
{
	global $mysqli;
	$activeInt = 1;
	if ($active == false) {
		$activeInt = 0;
	}
	$query = $mysqli->prepare("UPDATE dns SET name=?, url=?,username=?,password=?, active=? WHERE id=?");
	$query->bind_param("ssssii", $name, $url, $username, $password, $activeInt, $id);
	$query->execute();
	clearDNSSessions();
}
function loadDNSForUser($username, $password)
{
	$passwordHash = hash("sha256", $password);
	global $mysqli;
	$returnable = array();
	$query = $mysqli->prepare("SELECT dns.*,dns_sessions.id as checked FROM dns LEFT JOIN dns_sessions ON dns_sessions.dns_id = dns.id AND dns_sessions.username = ? and dns_sessions.password_hash = ? AND dns_sessions.last_used > NOW() - INTERVAL 1 DAY ORDER BY dns_sessions.dns_id DESC, dns.id ASC");
	$query->bind_param("ss", $username, $passwordHash);
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$thisDNS = array();
		$thisDNS['id'] = $resultArray['id'];
		$thisDNS['name'] = $resultArray['name'];
		$thisDNS['portal'] = $resultArray['url'];
		$thisDNS['active'] = $resultArray['active'];
		$thisDNS['checked'] = $resultArray['checked'];
		$returnable[] = $thisDNS;
	}
	return $returnable;
}
function clearDNSSessions()
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM dns_sessions;");
	$query->execute();
}
function saveDNSForUser($dns, $username, $password)
{
	$passwordHash = hash("sha256", $password);
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM dns_sessions WHERE dns_id = ? AND username = ? AND password_hash = ?");
	$query->bind_param("iss", $dns, $username, $passwordHash);
	$query->execute();
	$result = $query->get_result();
	if ($result->num_rows > 0) {
		$resultArray = $result->fetch_array();
		$query = $mysqli->prepare("UPDATE dns_sessions SET last_used = NOW() WHERE id = ?");
		$query->bind_param("i", $resultArray['id']);
		$query->execute();
	} else {
		$query = $mysqli->prepare("INSERT INTO dns_sessions (dns_id, date_added, last_used, username, password_hash) VALUES(?, NOW(), NOW(), ?, ?);");
		$query->bind_param("iss", $dns, $username, $passwordHash);
		$query->execute();
	}
}
function loadAllDNS($activeOnly = false)
{
	global $mysqli;
	$returnable = array();
	if ($activeOnly) {
		$query = $mysqli->prepare("SELECT * FROM dns;");
	} else {
		$query = $mysqli->prepare("SELECT * FROM dns WHERE active = 1;");
	}
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$thisDNS = array();
		$thisDNS['id'] = $resultArray['id'];
		$thisDNS['name'] = $resultArray['name'];
		$thisDNS['portal'] = $resultArray['url'];
		$thisDNS['active'] = $resultArray['active'];
		$thisDNS['username'] = $resultArray['username'];
		$thisDNS['password'] = $resultArray['password'];
		$returnable[] = $thisDNS;
	}
	return $returnable;
}
function loadDNS($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM dns WHERE id = ?;");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['id'] = $resultArray['id'];
	$returnable['name'] = $resultArray['name'];
	$returnable['portal'] = $resultArray['url'];
	$returnable['active'] = $resultArray['active'];
	$returnable['username'] = $resultArray['username'];
	$returnable['password'] = $resultArray['password'];
	return $returnable;
}

function saveProfile($id, $username, $password)
{
	$passwordHash = password_hash($password, PASSWORD_DEFAULT);
	global $mysqli;
	$query = $mysqli->prepare("UPDATE users SET	username=?, password_hash=? WHERE id=?");
	$query->bind_param("ssi", $username, $passwordHash, $id);
	$query->execute();
}
function loadProfile($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM users WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['username'] = $resultArray['username'];
	$returnable['password'] = '******';
	return $returnable;
}

function addMessage($text, $user)
{
	global $mysqli;
	$query = $mysqli->prepare("INSERT INTO messages (text, user, active) VALUES (?,?,1)");
	$query->bind_param("ss", $text, $user);
	$query->execute();
}

function saveMessage($id, $text, $user, $active)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE messages SET	text=?, user=?, active=? WHERE id=?");
	$query->bind_param("ssii", $text, $user, $active, $id);
	$query->execute();
}
function deleteMessage($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM messages WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function loadMessage($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM messages WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['id'] = $resultArray['id'];
	$returnable['user'] = $resultArray['user'];
	$returnable['text'] = $resultArray['text'];
	$returnable['date_added'] = $resultArray['date_added'];
	$returnable['active'] = $resultArray['active'];
	return $returnable;
}
function loadAllMessages($activeOnly = false)
{
	$returnable = array();
	global $mysqli;
	if ($activeOnly) {
		$query = $mysqli->prepare("SELECT * FROM messages where active = 1");
	} else {
		$query = $mysqli->prepare("SELECT * FROM messages");
	}
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {

		$thisMessage = array();
		$thisMessage['id'] = $resultArray['id'];
		$thisMessage['user'] = $resultArray['user'];
		$thisMessage['text'] = $resultArray['text'];
		$thisMessage['date_added'] = $resultArray['date_added'];
		$thisMessage['active'] = $resultArray['active'];
		$returnable[] = $thisMessage;
	}
	return $returnable;
}

function addNotification($title, $text)
{
	global $mysqli;
	$query = $mysqli->prepare("INSERT INTO notifications (notification_title, notification_text, active) VALUES (?,?,1)");
	$query->bind_param("ss", $title, $text);
	$query->execute();
}

function saveNotification($id, $title, $text, $active)
{
	$activeInt = 1;
	if ($active == false) {
		$activeInt = 0;
	}
	global $mysqli;
	$query = $mysqli->prepare("UPDATE notifications SET	notification_title=?, notification_text=?, active=? WHERE id=?");
	$query->bind_param("ssii", $title, $text, $activeInt, $id);
	$query->execute();
}
function deleteNotification($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM notifications WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function loadNotification($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM notifications WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['id'] = $resultArray['id'];
	$returnable['title'] = $resultArray['notification_title'];
	$returnable['text'] = $resultArray['notification_text'];
	$returnable['date_added'] = $resultArray['date_added'];
	$returnable['active'] = $resultArray['active'];
	return $returnable;
}
function loadAllNotifications($activeOnly = false)
{
	$returnable = array();
	global $mysqli;
	if ($activeOnly) {
		$query = $mysqli->prepare("SELECT * FROM notifications where active = 1");
	} else {
		$query = $mysqli->prepare("SELECT * FROM notifications");
	}
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {

		$thisNotification = array();
		$thisNotification['id'] = $resultArray['id'];
		$thisNotification['title'] = $resultArray['notification_title'];
		$thisNotification['text'] = $resultArray['notification_text'];
		$thisNotification['date_added'] = $resultArray['date_added'];
		$thisNotification['active'] = $resultArray['active'];
		$returnable[] = $thisNotification;
	}
	return $returnable;
}

//Ads
function addAd($name, $path)
{
	global $mysqli;
	$query = $mysqli->prepare("INSERT INTO ads (name, path, active) VALUES (?,?,1)");
	$query->bind_param("ss", $name, $path);
	$query->execute();
}

function saveAd($id, $name, $path, $active)
{
	$activeInt = 1;
	if ($active == false) {
		$activeInt = 0;
	}
	global $mysqli;
	if ($path == "") {
		$query = $mysqli->prepare("UPDATE ads SET	name=?, active=? WHERE id=?");
		$query->bind_param("sii", $name, $activeInt, $id);
	} else {
		$query = $mysqli->prepare("UPDATE ads SET	name=?, path=?, active=? WHERE id=?");
		$query->bind_param("ssii", $name, $path, $activeInt, $id);
	}
	$query->execute();
}

function deleteAd($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ads WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function loadAd($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ads WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['id'] = $resultArray['id'];
	$returnable['name'] = $resultArray['name'];
	$returnable['path'] = $resultArray['path'];
	$returnable['active'] = $resultArray['active'];
	return $returnable;
}
function loadAllAds($onlyActive = false)
{
	$returnable = array();
	global $mysqli;
	if ($onlyActive) {
		$query = $mysqli->prepare("SELECT * FROM ads WHERE active = 1");
	} else {
		$query = $mysqli->prepare("SELECT * FROM ads");
	}
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$thisNotification = array();
		$thisNotification['id'] = $resultArray['id'];
		$thisNotification['name'] = $resultArray['name'];
		$thisNotification['path'] = $resultArray['path'];
		$thisNotification['active'] = $resultArray['active'];
		$returnable[] = $thisNotification;
	}
	return $returnable;
}
//VPN
function addVpn($location, $path, $authType, $username, $password, $auth_embedded)
{
	global $mysqli;
	$query = $mysqli->prepare("INSERT INTO vpn (location, path, active, auth_type, username, password, date_added, auth_embedded) VALUES (?,?,1,?,?,?,NOW(),?)");
	$query->bind_param("sssssi", $location, $path, $authType, $username, $password, $auth_embedded);
	$query->execute();
}

function saveVpn($id, $location, $path, $active, $authType, $username, $password, $auth_embedded)
{
	$activeInt = 1;
	if ($active == false) {
		$activeInt = 0;
	}
	$authInt = 1;
	if ($auth_embedded == false) {
		$authInt = 0;
	}
	global $mysqli;

	$query = $mysqli->prepare("UPDATE vpn SET location=?,path=?, active=?, auth_type=?, username=?, password=?, auth_embedded=? WHERE id=?");
	$query->bind_param("ssisssii", $location, $path, $activeInt, $authType, $username, $password, $authInt, $id);
	$query->execute();
}
function deleteVpn($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM vpn WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function loadVpn($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM vpn WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['id'] = $resultArray['id'];
	$returnable['location'] = $resultArray['location'];
	$returnable['path'] = $resultArray['path'];
	$returnable['active'] = $resultArray['active'];
	$returnable['auth_type'] = $resultArray['auth_type'];
	$returnable['username'] = $resultArray['username'];
	$returnable['password'] = $resultArray['password'];
	$returnable['auth_embedded'] = $resultArray['auth_embedded'];
	return $returnable;
}
function loadAllVpn($activeOnly = false)
{
	$returnable = array();
	global $mysqli;
	if ($activeOnly) {
		$query = $mysqli->prepare("SELECT * FROM vpn where active = 1");
	} else {
		$query = $mysqli->prepare("SELECT * FROM vpn");
	}

	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$thisVpn = array();
		$thisVpn['id'] = $resultArray['id'];
		$thisVpn['location'] = $resultArray['location'];
		$thisVpn['path'] = $resultArray['path'];
		$thisVpn['active'] = $resultArray['active'];
		$thisVpn['auth_type'] = $resultArray['auth_type'];
		$thisVpn['username'] = $resultArray['username'];
		$thisVpn['password'] = $resultArray['password'];
		$thisVpn['auth_embedded'] = $resultArray['auth_embedded'];
		$returnable[] = $thisVpn;
	}
	return $returnable;
}
//Intro
function loadIntro()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM intro");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$returnable = array();
	$returnable['path'] = $resultArray['path'];
	$returnable['active'] = $resultArray['active'];
	return $returnable;
}

function saveIntro($path, $active)
{
	$activeInt = 1;
	if ($active == false) {
		$activeInt = 0;
	}
	global $mysqli;
	if ($path == "") {
		$query = $mysqli->prepare("UPDATE intro SET active=?");
		$query->bind_param("i", $activeInt);
	} else {
		$query = $mysqli->prepare("UPDATE intro SET path=?, active=?");
		$query->bind_param("si", $path, $activeInt);
	}

	$query->execute();
}
//XCIPTV
function saveXCIPTVOptionsApp($app_name, $app_build, $app_identifier, $login_type, $login_accounts_button, $log_settings_button, $announcements, $messages, $update_user_info, $developer_name, $developer_contact, $signup_url, $login_logo, $app_logs, $category_count, $user_agent, $load_last_channel, $proxy_traffic, $licv4_method, $licv3_key, $licv3_iv)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE xciptv_options SET app_name=?, app_build=?, app_identifier=?, login_type=?, login_accounts_button=?, log_settings_button=?, announcements=?, messages=?, update_user_info=?, developer_name=?, developer_contact=?, signup_url=?, login_logo=?, app_logs=?, category_count=?, user_agent=?, load_last_channel=?, proxy_traffic=?, licv4_method=?, licv3_key=?, licv3_iv=?;");
	$query->bind_param("ssssiiiiisssiiisiiiss", $app_name, $app_build, $app_identifier, $login_type, $login_accounts_button, $log_settings_button, $announcements, $messages, $update_user_info, $developer_name, $developer_contact, $signup_url, $login_logo, $app_logs, $category_count, $user_agent, $load_last_channel, $proxy_traffic, $licv4_method, $licv3_key, $licv3_iv);
	$query->execute();
}

function saveXCIPTVOptionsButtons($show_live, $show_epg, $show_vod, $show_series, $show_catchup, $show_radio, $show_multi, $show_favorite, $show_account, $show_reminders, $show_record, $show_vpn, $show_message, $show_update, $show_expiry, $theme)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE xciptv_options SET show_live=?, show_epg=?, show_vod=?, show_series=?, show_catchup=?, show_radio=?, show_multi=?, show_favorite=?, show_account=?, show_reminders=?, show_record=?, show_vpn=?, show_message=?, show_update=?, show_expiry=?, theme=?");
	$query->bind_param("iiiiiiiiiiiiiiis", $show_live, $show_epg, $show_vod, $show_series, $show_catchup, $show_radio, $show_multi, $show_favorite, $show_account, $show_reminders, $show_record, $show_vpn, $show_message, $show_update, $show_expiry, $theme);
	$query->execute();
}
function saveXCIPTVOptionsButtonsPortal($number, $show_live, $show_epg, $show_vod, $show_series, $show_catchup, $show_radio, $show_multi, $show_favorite, $show_account)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE xciptv_options SET show_live" . $number . "=?, show_epg" . $number . "=?, show_vod" . $number . "=?, show_series" . $number . "=?, show_catchup" . $number . "=?, show_radio" . $number . "=?, show_multi" . $number . "=?, show_favorite" . $number . "=?, show_account" . $number . "=?");
	$query->bind_param("iiiiiiiii", $show_live, $show_epg, $show_vod, $show_series, $show_catchup, $show_radio, $show_multi, $show_favorite, $show_account);
	$query->execute();
}
function saveXCIPTVOptionsPlayer($exo_buffer, $exo_zoom, $exo_hw, $exo_subtitles, $exo_volume, $vlc_buffer, $vlc_zoom, $vlc_hw, $vlc_subtitles, $vlc_volume, $player_live, $player_epg, $player_vod, $player_series)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE xciptv_options SET exo_buffer=?, exo_zoom=?, exo_hw=?, exo_subtitles=?, exo_volume=?, vlc_buffer=?, vlc_zoom=?, vlc_hw=?, vlc_subtitles=?, vlc_volume=?, player_live=?, player_epg=?, player_vod=?, player_series=?;");
	$query->bind_param("ssiisssiisssss", $exo_buffer, $exo_zoom, $exo_hw, $exo_subtitles, $exo_volume, $vlc_buffer, $vlc_zoom, $vlc_hw, $vlc_subtitles, $vlc_volume, $player_live, $player_epg, $player_vod, $player_series);
	$query->execute();
}
function loadXCIPTVOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM xciptv_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	return $resultArray;
}
function loadPurpleOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM purple_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	return $resultArray;
}
function savePurpleOptions($proxy_traffic, $startup_msg, $allow_4k, $vpn, $vpn_login_screen, $allow_cast, $remote_support, $wifi_option, $setting_option, $app_list_status, $epg_timeshift, $catchup, $epg_catchup, $recording, $multi_recording, $intro_video, $theme_change_allow, $multi_profile, $server_selection, $about_description, $about_developed, $about_name, $about_skype, $about_telegram, $about_whatsapp)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE purple_options SET proxy_traffic=?, startup_msg=?, allow_4k=?, vpn=?, vpn_login_screen=?, allow_cast=?, remote_support=?, wifi_option=?, setting_option=?, app_list_status=?, epg_timeshift=?, catchup=?, epg_catchup=?, recording=?, multi_recording=?, intro_video=?, theme_change_allow=?, multi_profile=?, server_selection=?, about_description=?, about_developed=?, about_name=?, about_skype=?, about_telegram=?, about_whatsapp=?;");
	$query->bind_param("isiiiiiiiiiiiiiiiiissssss", $proxy_traffic, $startup_msg, $allow_4k, $vpn, $vpn_login_screen, $allow_cast, $remote_support, $wifi_option, $setting_option, $app_list_status, $epg_timeshift, $catchup, $epg_catchup, $recording, $multi_recording, $intro_video, $theme_change_allow, $multi_profile, $server_selection, $about_description, $about_developed, $about_name, $about_skype, $about_telegram, $about_whatsapp);
	$query->execute();
}
function savePurpleInterfaceOptions($app_img, $app_logo, $app_mobile_icon, $app_tv_banner, $splash_image, $back_image, $background_auto_change, $background_mannual_change, $background_orverlay_color_code, $background_url1, $background_url2, $background_url3, $background_url4)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE purple_options SET app_img=?, app_logo=?, app_mobile_icon=?, app_tv_banner=?, splash_image=?, back_image=?, background_auto_change=?, background_mannual_change=?, background_orverlay_color_code=?, background_url1=?, background_url2=?, background_url3=?, background_url4=?;");
	$query->bind_param("isssssiisssss", $app_img, $app_logo, $app_mobile_icon, $app_tv_banner, $splash_image, $back_image, $background_auto_change, $background_mannual_change, $background_orverlay_color_code, $background_url1, $background_url2, $background_url3, $background_url4);
	$query->execute();
}
function loadSportsOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM sports_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	return $resultArray;
}
function saveSportsOptions($api_key, $header_name, $border_colour, $background_colour, $text_colour)
{
	global $mysqli;
	$query = $mysqli->prepare("UPDATE sports_options SET api_key=?, header_name=?, border_colour=?, background_colour=?, text_colour=?;");
	$query->bind_param("sssss", $api_key, $header_name, $border_colour, $background_colour, $text_colour);
	$query->execute();
}

function loadLTQDOptions()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_options");
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	return $resultArray;
}
function loadLTQDAppstore()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_appstore");
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function loadLTQDAppstoreApp($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_appstore WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	return $result->fetch_array();
}
function loadLTQDSections()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_sections ORDER BY order_no");
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function loadLTQDSection($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_sections WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	return $result->fetch_array();
}
function loadLTQDSectionItems($sectionId)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_section_items WHERE section_id = ? ORDER BY order_no");
	$query->bind_param("i", $sectionId);
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function loadLTQDSectionItem($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_section_items WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	return $result->fetch_array();
}
function loadLTQDSportsCategories()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_sports_categories");
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function loadLTQDSportsCategory($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_sports_categories WHERE id = ?");
	$query->bind_param("i", $id);

	$query->execute();
	$result = $query->get_result();
	return $result->fetch_array();
}
function loadLTQDSportsEventsDisplay()
{
	global $mysqli;

	$query = $mysqli->prepare("SELECT ltqd_sports_events.*, cat.title as category_id, ta.name as team_a_id, tb.name as team_b_id
	 FROM ltqd_sports_events 
	LEFT JOIN ltqd_sports_teams ta on ltqd_sports_events.team_a_id = ta.id
	LEFT JOIN ltqd_sports_teams tb on ltqd_sports_events.team_b_id = tb.id
	LEFT JOIN ltqd_sports_categories cat on ltqd_sports_events.category_id = cat.id ORDER BY start_timestamp");
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function loadLTQDSportsEvents($category = 0)
{
	global $mysqli;
	if ($category == 0) {
		$query = $mysqli->prepare("SELECT * FROM ltqd_sports_events ORDER BY start_timestamp");
	} else {
		$query = $mysqli->prepare("SELECT * FROM ltqd_sports_events WHERE category_id = ? ORDER BY start_timestamp");
		$query->bind_param("i", $category);
	}
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function loadLTQDSportsEvent($id)
{
	global $mysqli;

	$query = $mysqli->prepare("SELECT * FROM ltqd_sports_events WHERE id = ?");
	$query->bind_param("i", $id);

	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	return $result->fetch_array();
}
//SECURITY NOTE - never let $tableName be set by user - always harcoded
//TODO: maybe add list of allowed tables, just in case.
function addDbEntry($tableName, $data)
{

	global $mysqli;
	$fields = "";
	$values = "";
	foreach ($data as $fieldName => $fieldValue) {
		if ($fields != "") {
			$fields .= ", ";
		}
		$fields .= $fieldName;
		if ($values != "") {
			$values .= ", ";
		}
		$values .= "'" . $mysqli->real_escape_string($fieldValue) . "'";
	}
	$query = "INSERT INTO $tableName ($fields) VALUES ($values)";
	$mysqli->query($query);
}
//SECURITY NOTE - never let $tableName be set by user - always harcoded
//TODO: maybe add list of allowed tables, just in case.
function updateDbEntry($tableName, $data)
{
	global $mysqli;
	$where = "";
	if (isset($data['id'])) {
		$where = " WHERE id = " . $data['id'];
	}
	unset($data['id']);
	$fields = "";
	foreach ($data as $fieldName => $fieldValue) {
		if ($fields != "") {
			$fields .= ", ";
		}
		$fields .= $fieldName;

		$fields .= "='" . $mysqli->real_escape_string($fieldValue) . "'";
	}
	$query = "UPDATE $tableName SET " . $fields . $where;
	$mysqli->query($query);
}

function loadLTQDSportsTeams()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_sports_teams");
	
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}

function loadLTQDSportsTeam($teamId)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_sports_teams WHERE id = ?");
	$query->bind_param("i", $teamId);
	$query->execute();
	$result = $query->get_result();
	$returnable = $result->fetch_array();
	return $returnable;
}
function loadLTQDThemes()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_themes");
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function loadLTQDReports()
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_channel_reports");
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function loadLTQDTheme($id)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_themes WHERE id = ?");
	$query->bind_param("i", $id);
	$query->execute();
	$result = $query->get_result();
	return $result->fetch_array();
}
function loadLTQDMessages($username)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_messages WHERE username = ?");
	$query->bind_param("s", $username);
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function addLTQDMessage($username, $content, $outbound)
{
	global $mysqli;
	$insertQuery = $mysqli->prepare("INSERT INTO ltqd_messages (message_text, username, message_datetime, message_outbound) VALUES(?, ?, ?, ?);");
	$insertQuery->bind_param("ssii", $content, $username,time(),$outbound);
	$insertQuery->execute();
}
function ascii2hex($ascii)
{
	$hex = '';
	for ($i = 0; $i < strlen($ascii); $i++) {
		$byte = strtoupper(dechex(ord($ascii[$i])));
		$byte = str_repeat('0', 2 - strlen($byte)) . $byte;
		$hex .= $byte . "";
	}
	return $hex;
}

function hex2str($hex)
{
	$str = '';
	for ($i = 0; $i < strlen($hex); $i += 2) $str .= chr(hexdec(substr($hex, $i, 2)));
	return $str;
}
function qdEncrypt($input)
{
	global $key;
	global $iv;
	$encrypted = openssl_encrypt($input, 'aes-256-cbc', $key, 0, $iv);
	return $encrypted;
}

function qdDecrypt($input)
{
	global $key;
	global $iv;
	$decrypted = openssl_decrypt($input, 'aes-256-cbc', $key, 0, $iv);
	return $decrypted;
}

function getAuthorizationHeader()
{
	$headers = null;
	if (isset($_SERVER['Authorization'])) {
		$headers = trim($_SERVER["Authorization"]);
	} else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
		$headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
	} elseif (function_exists('apache_request_headers')) {
		$requestHeaders = apache_request_headers();
		$requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
		if (isset($requestHeaders['Authorization'])) {
			$headers = trim($requestHeaders['Authorization']);
		}
	}
	return $headers;
}

/**
 * get access token from header
 * */
function getBearerToken()
{
	$headers = getAuthorizationHeader();
	// HEADER: Get the access token from the header
	if (!empty($headers)) {
		if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
			return $matches[1];
		}
	}
	return null;
}
function refreshMovies($id)
{
	global $mysqli;
	$refreshHash = md5(time());
	$dnsInfo = loadDNS($id);
	$portalUrl = $dnsInfo['portal'];
	//grab the categories.
	$baseUrl = $portalUrl . "/player_api.php?username=" . $dnsInfo['username'] . "&password=" . $dnsInfo['password'];
	$catResponse = callApi($baseUrl . "&action=get_vod_categories");
	
	$categories = json_decode($catResponse['data'], true);
	foreach ($categories as $thisCategory) {
		//first check if we already have it.
		$query = $mysqli->prepare("SELECT * FROM movie_categories WHERE dns_id = ? and ref = ?");
		$query->bind_param("ii", $id, $thisCategory['category_id']);
		$query->execute();
		$result = $query->get_result();
		if ($result->num_rows) {
			//uupdate it
			$updateQuery = $mysqli->prepare("UPDATE movie_categories SET name = ?, refresh_hash=? WHERE dns_id = ? AND ref = ?");
			$updateQuery->bind_param("ssii", $thisCategory['category_name'], $refreshHash, $id, $thisCategory['category_id']);
			$updateQuery->execute();
		} else {
			//add it
			$insertQuery = $mysqli->prepare("INSERT INTO movie_categories (dns_id, name, ref,refresh_hash) VALUES (?,?,?,?);");
			$insertQuery->bind_param("isis", $id, $thisCategory['category_name'], $thisCategory['category_id'], $refreshHash);
			$insertQuery->execute();
		}
	}
	//now delete unneeded
	$deleteQuery = $mysqli->prepare("DELETE FROM movie_categories WHERE dns_id = ? AND refresh_hash != ?;");
	$deleteQuery->bind_param("is", $id, $refreshHash);
	$deleteQuery->execute();

	$chanResponse = callApi($baseUrl . "&action=get_vod_streams");
	$channels = json_decode($chanResponse['data'], true);
	foreach ($channels as $thisChannel) {
		//first check if we already have it.
		$query = $mysqli->prepare("SELECT * FROM movie_streams WHERE dns_id = ? and stream_id = ?");
		$query->bind_param("ii", $id, $thisChannel['stream_id']);
		$query->execute();
		$result = $query->get_result();
		if ($result->num_rows) {
			//uupdate it
			$updateQuery = $mysqli->prepare("UPDATE movie_streams SET name = ?, refresh_hash=?, category_id = ? WHERE dns_id = ? AND stream_id = ?");
			$updateQuery->bind_param("ssiii", $thisChannel['name'], $refreshHash, $thisChannel['category_id'], $id, $thisChannel['stream_id']);
			$updateQuery->execute();
		} else {
			//add it
			$insertQuery = $mysqli->prepare("INSERT INTO movie_streams (dns_id, name,  stream_id, category_id,refresh_hash) VALUES (?,?,?,?,?);");
			$insertQuery->bind_param("isiis", $id, $thisChannel['name'], $thisChannel['stream_id'], $thisChannel['category_id'], $refreshHash);
			$insertQuery->execute();
		}
	}
	//now delete unneeded
	$deleteQuery = $mysqli->prepare("DELETE FROM movie_streams WHERE dns_id = ? AND refresh_hash != ?;");
	$deleteQuery->bind_param("is", $id, $refreshHash);
	$deleteQuery->execute();
}
function refreshTV($id)
{
	global $mysqli;
	$refreshHash = md5(time());
	$dnsInfo = loadDNS($id);
	$portalUrl = $dnsInfo['portal'];
	//grab the categories.
	$baseUrl = $portalUrl . "/player_api.php?username=" . $dnsInfo['username'] . "&password=" . $dnsInfo['password'];
	$catResponse = callApi($baseUrl . "&action=get_series_categories");
	
	$categories = json_decode($catResponse['data'], true);
	foreach ($categories as $thisCategory) {
		//first check if we already have it.
		$query = $mysqli->prepare("SELECT * FROM tv_categories WHERE dns_id = ? and ref = ?");
		$query->bind_param("ii", $id, $thisCategory['category_id']);
		$query->execute();
		$result = $query->get_result();
		if ($result->num_rows) {
			//uupdate it
			$updateQuery = $mysqli->prepare("UPDATE tv_categories SET name = ?, refresh_hash=? WHERE dns_id = ? AND ref = ?");
			$updateQuery->bind_param("ssii", $thisCategory['category_name'], $refreshHash, $id, $thisCategory['category_id']);
			$updateQuery->execute();
		} else {
			//add it
			$insertQuery = $mysqli->prepare("INSERT INTO tv_categories (dns_id, name, ref,refresh_hash) VALUES (?,?,?,?);");
			$insertQuery->bind_param("isis", $id, $thisCategory['category_name'], $thisCategory['category_id'], $refreshHash);
			$insertQuery->execute();
		}
	}
	//now delete unneeded
	$deleteQuery = $mysqli->prepare("DELETE FROM tv_categories WHERE dns_id = ? AND refresh_hash != ?;");
	$deleteQuery->bind_param("is", $id, $refreshHash);
	$deleteQuery->execute();

	$chanResponse = callApi($baseUrl . "&action=get_series");
	$channels = json_decode($chanResponse['data'], true);
	foreach ($channels as $thisChannel) {
		//first check if we already have it.
		$query = $mysqli->prepare("SELECT * FROM tv_series WHERE dns_id = ? and series_id = ?");
		$query->bind_param("ii", $id, $thisChannel['stream_id']);
		$query->execute();
		$result = $query->get_result();
		if ($result->num_rows) {
			//uupdate it
			$updateQuery = $mysqli->prepare("UPDATE tv_series SET name = ?, refresh_hash=?, category_id = ? WHERE dns_id = ? AND series_id = ?");
			$updateQuery->bind_param("ssiii", $thisChannel['name'], $refreshHash, $thisChannel['category_id'], $id, $thisChannel['series_id']);
			$updateQuery->execute();
		} else {
			//add it
			$insertQuery = $mysqli->prepare("INSERT INTO tv_series (dns_id, name,  series_id, category_id,refresh_hash) VALUES (?,?,?,?,?);");
			$insertQuery->bind_param("isiis", $id, $thisChannel['name'], $thisChannel['series_id'], $thisChannel['category_id'], $refreshHash);
			$insertQuery->execute();
		}
	}
	//now delete unneeded
	$deleteQuery = $mysqli->prepare("DELETE FROM tv_series WHERE dns_id = ? AND refresh_hash != ?;");
	$deleteQuery->bind_param("is", $id, $refreshHash);
	$deleteQuery->execute();
}
function refreshChannels($id)
{
	global $mysqli;
	$refreshHash = md5(time());
	$dnsInfo = loadDNS($id);
	$portalUrl = $dnsInfo['portal'];
	//grab the categories.
	$baseUrl = $portalUrl . "/player_api.php?username=" . $dnsInfo['username'] . "&password=" . $dnsInfo['password'];
	$catResponse = callApi($baseUrl . "&action=get_live_categories");
	
	$categories = json_decode($catResponse['data'], true);
	foreach ($categories as $thisCategory) {
		//first check if we already have it.
		$query = $mysqli->prepare("SELECT * FROM dns_categories WHERE dns_id = ? and category_ref = ?");
		$query->bind_param("ii", $id, $thisCategory['category_id']);
		$query->execute();
		$result = $query->get_result();
		if ($result->num_rows) {
			//uupdate it
			$updateQuery = $mysqli->prepare("UPDATE dns_categories SET category_name = ?, refresh_hash=? WHERE dns_id = ? AND category_ref = ?");
			$updateQuery->bind_param("ssii", $thisCategory['category_name'], $refreshHash, $id, $thisCategory['category_id']);
			$updateQuery->execute();
		} else {
			//add it
			$insertQuery = $mysqli->prepare("INSERT INTO dns_categories (dns_id, category_name, category_ref,refresh_hash) VALUES (?,?,?,?);");
			$insertQuery->bind_param("isis", $id, $thisCategory['category_name'], $thisCategory['category_id'], $refreshHash);
			$insertQuery->execute();
		}
	}
	//now delete unneeded
	$deleteQuery = $mysqli->prepare("DELETE FROM dns_categories WHERE dns_id = ? AND refresh_hash != ?;");
	$deleteQuery->bind_param("is", $id, $refreshHash);
	$deleteQuery->execute();

	$chanResponse = callApi($baseUrl . "&action=get_live_streams");
	$channels = json_decode($chanResponse['data'], true);
	foreach ($channels as $thisChannel) {
		//first check if we already have it.
		$query = $mysqli->prepare("SELECT * FROM dns_channels WHERE dns_id = ? and channel_number = ?");
		$query->bind_param("ii", $id, $thisChannel['stream_id']);
		$query->execute();
		$result = $query->get_result();
		if ($result->num_rows) {
			//uupdate it
			$updateQuery = $mysqli->prepare("UPDATE dns_channels SET channel_name = ?, channel_epg_name=?, refresh_hash=?, category_id = ? WHERE dns_id = ? AND channel_number = ?");
			$updateQuery->bind_param("sssiii", $thisChannel['name'], $thisChannel['epg_channel_id'], $refreshHash, $thisChannel['category_id'], $id, $thisChannel['stream_id']);
			$updateQuery->execute();
		} else {
			//add it
			$insertQuery = $mysqli->prepare("INSERT INTO dns_channels (dns_id, channel_name, channel_epg_name, channel_number, category_id,refresh_hash) VALUES (?,?,?,?,?,?);");
			$insertQuery->bind_param("issiis", $id, $thisChannel['name'], $thisChannel['epg_channel_id'], $thisChannel['stream_id'], $thisChannel['category_id'], $refreshHash);
			$insertQuery->execute();
		}
	}
	//now delete unneeded
	$deleteQuery = $mysqli->prepare("DELETE FROM dns_channels WHERE dns_id = ? AND refresh_hash != ?;");
	$deleteQuery->bind_param("is", $id, $refreshHash);
	$deleteQuery->execute();
}

function getCategories($dnsId)
{
	$returnable = array();
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM dns_categories WHERE dns_id = ?");
	$query->bind_param("i", $dnsId);
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function getCategoriesTV($dnsId)
{
	$returnable = array();
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM tv_categories WHERE dns_id = ?");
	$query->bind_param("i", $dnsId);
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function getCategoriesMovie($dnsId)
{
	$returnable = array();
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM movie_categories WHERE dns_id = ?");
	$query->bind_param("i", $dnsId);
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function getChannels($categoryId)
{
	$returnable = array();
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM dns_categories WHERE id = ?");
	$query->bind_param("i", $categoryId);
	$query->execute();
	$result = $query->get_result();
	$resultArray = $result->fetch_array();
	$dnsId = $resultArray['dns_id'];
	$categoryRef = $resultArray['category_ref'];
	$query = $mysqli->prepare("SELECT * FROM dns_channels WHERE category_id = ? AND dns_id = ?");
	$query->bind_param("ii", $categoryRef, $dnsId);
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function addEventStream($eventId, $streamId)
{
	global $mysqli;
	$insertQuery = $mysqli->prepare("INSERT INTO ltqd_sports_event_channels (event_id, channel_id) VALUES(?, ?);");
	$insertQuery->bind_param("ii", $eventId, $streamId);
	$insertQuery->execute();
}

function getEventStreams($eventId)
{
	$returnable = array();
	$queryStr = 'select * from ltqd_sports_event_channels ch 
	left join dns_channels dc on ch.channel_id = dc.id
	left join dns_categories dc2 on dc.category_id = dc2.category_ref AND dc.dns_id = dc2.dns_id 
	left join dns on dc.dns_id = dns.id
	where ch.event_id = ?';
	global $mysqli;
	$query = $mysqli->prepare($queryStr);
	$query->bind_param("i", $eventId);
	$query->execute();
	$result = $query->get_result();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray;
	}
	return $returnable;
}
function removeEventStream($channelId, $eventId)
{

	global $mysqli;
	$insertQuery = $mysqli->prepare("DELETE FROM ltqd_sports_event_channels WHERE event_id = ? AND channel_id = ?;");
	$insertQuery->bind_param("ii", $eventId, $channelId);
	$insertQuery->execute();
}
function getEventStreamIDs($dnsId, $eventId)
{

	$queryStr = 'select * from ltqd_sports_event_channels ch 
	left join dns_channels dc on ch.channel_id = dc.id
	left join dns on dc.dns_id = dns.id
	where ch.event_id = ? AND dns.url LIKE ?';
	global $mysqli;
	$query = $mysqli->prepare($queryStr);
	$query->bind_param("is", $eventId, $dnsId);
	$query->execute();
	$result = $query->get_result();
	$returnable = array();
	while ($resultArray = $result->fetch_array()) {
		$returnable[] = $resultArray['channel_number'];
	}
	return $returnable;
}

function addChannelReport($dns, $username, $message, $stream_id, $type)
{
	global $mysqli;
	$query = $mysqli->prepare("SELECT * FROM ltqd_channel_reports WHERE username = ? AND message = ? AND stream_id=? AND type = ? AND report_date > (now() - interval 1 minute)");
	$query->bind_param("ssis",  $username, $message, $stream_id, $type);
	$query->execute();
	$result = $query->get_result();
	if (!$result->num_rows) {
		$query = $mysqli->prepare("INSERT INTO ltqd_channel_reports (username, message, `type`, stream_id, dns, report_date) VALUES(?, ?, ?, ?, ?, NOW());");
		$query->bind_param("sssis", $username, $message, $type, $stream_id, $dns);
		$query->execute();
	}
}
function deleteLTQDTheme($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ltqd_themes WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function deleteLTQDEvent($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ltqd_sports_events WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function recordDeleteLTQDEvent($id,$channel = null)
{
	global $mysqli;
	$query = $mysqli->prepare("INSERT INTO ltqd_sports_deleted_records (event_id,channel_id) VALUES(?,?);");
	$query->bind_param("ii", $id,$channel);
	$query->execute();
}
function checkDeleteLTQDEvent($id,$channel = null)
{
	global $mysqli;
	if($channel)
	{
	$query = $mysqli->prepare("SELECT * FROM ltqd_sports_deleted_records where event_id = ? AND channel_id = ?;");
	$query->bind_param("ii", $id,$channel);
	}
	else
	{
		$query = $mysqli->prepare("SELECT * FROM ltqd_sports_deleted_records where event_id = ? AND channel_id IS NULL;");
		$query->bind_param("i", $id);
	}
	$query->execute();
	$result = $query->get_result();
	if ($result->num_rows) {
		return true;
	}
	return false;
}
function deleteLTQDTeam($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ltqd_sports_teams WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function deleteLTQDCategory($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ltqd_sports_categories WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function deleteLTQDAppstore($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ltqd_appstore WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function deleteLTQDChannelReport($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ltqd_channel_reports WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function deleteLTQDSection($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ltqd_sections WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}
function deleteLTQDSectionItem($id)
{
	global $mysqli;
	$query = $mysqli->prepare("DELETE FROM ltqd_section_items WHERE id=?");
	$query->bind_param("i", $id);
	$query->execute();
}

function updateSports()
{
	global $mysqli;
	global $sportsApiKey;
	$leagues = loadLTQDSportsCategories();

	$refreshHash = md5(time());
	foreach($leagues as $league)
	{
		if($league['league_id'])
		{
			$teamIds = array();
			$teams = file_curl_contents("https://andyhax.uk/sports/" . $sportsApiKey . "/teams/" . $league['league_id']);
			$teamsInfo = json_decode($teams,true);
			foreach($teamsInfo as $thisTeam)
			{
				$checkQuery = $query = $mysqli->prepare("SELECT * FROM ltqd_sports_teams WHERE league_id = ? AND team_id = ?");
				$checkQuery->bind_param("ii", $league['league_id'],$thisTeam['id']);
				$checkQuery->execute();
				$result = $checkQuery->get_result();
				if (!$result->num_rows) 
				{
					$addQuery = $mysqli->prepare("INSERT INTO `ltqd_sports_teams` (`team_id`, `name`, `flag`, `league_id`, `update_hash`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, NOW(), NOW())");
					$addQuery->bind_param("issis", $thisTeam['id'],$thisTeam['name'],$thisTeam['flag'],$league['league_id'],$refreshHash);
					$addQuery->execute();
					$dbId = $addQuery->insert_id;
				}
				else
				{
					$resultArray = $result->fetch_array();
					$dbId = $resultArray['id'];
					$updateQuery = $mysqli->prepare("UPDATE ltqd_sports_teams SET update_hash = ? WHERE team_id = ? AND league_id = ?");
					$updateQuery->bind_param("sii", $refreshHash,$thisTeam['id'],$league['league_id']);
					$updateQuery->execute();
				}
				$teamIds[$thisTeam['id']] = $dbId;
			}
			$updateQuery = $mysqli->prepare("DELETE FROM ltqd_sports_teams WHERE league_id = ? AND update_hash != ?");
			$updateQuery->bind_param("is", $league['league_id'],$refreshHash);
			$updateQuery->execute();
	
		$events = file_curl_contents("https://andyhax.uk/sports/" . $sportsApiKey . "/events/" . $league['league_id']);
		$eventsInfo = json_decode($events,true);
			foreach($eventsInfo as $thisevent)
			{
				if(checkDeleteLTQDEvent($thisevent['id']))
				{
					continue;
				}
				$checkQuery = $query = $mysqli->prepare("SELECT * FROM ltqd_sports_events WHERE league_id = ? AND event_id = ?");
				$checkQuery->bind_param("ii", $league['league_id'],$thisevent['id']);
				$checkQuery->execute();
				$result = $checkQuery->get_result();
				
				$teamAId = $teamIds[$thisevent['team_a_id']];
				$teamBId = $teamIds[$thisevent['team_b_id']];
				if(!$teamAId && $thisevent['team_a_id'])
				{
					//need to check the database and then grab from the API if not.
					$teamQuery = $mysqli->prepare("SELECT * FROM ltqd_sports_teams WHERE league_id = ? AND team_id = ?");
					$teamQuery->bind_param("ii", $league['league_id'],$thisevent['team_a_id']);
					$teamQuery->execute();
					$teamResult = $teamQuery->get_result();
					if($teamResult->num_rows)
					{
						//got it already, get the id and add it
						$resultArray = $teamResult->fetch_array();
						$teamDbId = $resultArray['id'];
					}
					else{
						//don't have it, fetch it individually from the API
						$team = file_curl_contents("https://andyhax.uk/sports/" . $sportsApiKey . "/team/" . $thisevent['team_a_id']);
						$teamsInfo = json_decode($team,true);
						foreach($teamsInfo as $thisTeam)
						{
							$checkQuery = $query = $mysqli->prepare("SELECT * FROM ltqd_sports_teams WHERE league_id = ? AND team_id = ?");
							$checkQuery->bind_param("ii", $league['league_id'],$thisTeam['id']);
							$checkQuery->execute();
							$teamResult = $checkQuery->get_result();
							if (!$teamResult->num_rows) 
							{
								$addQuery = $mysqli->prepare("INSERT INTO `ltqd_sports_teams` (`team_id`, `name`, `flag`, `league_id`, `update_hash`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, NOW(), NOW())");
								$addQuery->bind_param("issis", $thisTeam['id'],$thisTeam['name'],$thisTeam['flag'],$league['league_id'],$refreshHash);
								$addQuery->execute();
								$teamDbId = $addQuery->insert_id;
							}
							else
							{
								$resultArray = $teamResult->fetch_array();
								$teamDbId = $resultArray['id'];
								$updateQuery = $mysqli->prepare("UPDATE ltqd_sports_teams SET update_hash = ? WHERE team_id = ? AND league_id = ?");
								$updateQuery->bind_param("sii", $refreshHash,$thisTeam['id'],$league['league_id']);
								$updateQuery->execute();
							}
						}
					}
					$teamAId = $teamDbId;
				}
				if(!$teamBId && $thisevent['team_b_id'])
				{
					//need to check the database and then grab from the API if not.
					$teamQuery = $mysqli->prepare("SELECT * FROM ltqd_sports_teams WHERE league_id = ? AND team_id = ?");
					$teamQuery->bind_param("ii", $league['league_id'],$thisevent['team_b_id']);
					$teamQuery->execute();
					$teamResult = $teamQuery->get_result();
					if($teamResult->num_rows)
					{
						//got it already, get the id and add it
						$resultArray = $teamResult->fetch_array();
						$teamDbId = $resultArray['id'];
					}
					else{
						//don't have it, fetch it individually from the API
						$team = file_curl_contents("https://andyhax.uk/sports/" . $sportsApiKey . "/team/" . $thisevent['team_b_id']);
						$teamsInfo = json_decode($team,true);
						foreach($teamsInfo as $thisTeam)
						{
							$checkQuery = $query = $mysqli->prepare("SELECT * FROM ltqd_sports_teams WHERE league_id = ? AND team_id = ?");
							$checkQuery->bind_param("ii", $league['league_id'],$thisTeam['id']);
							$checkQuery->execute();
							$teamResult = $checkQuery->get_result();
							if (!$teamResult->num_rows) 
							{
								$addQuery = $mysqli->prepare("INSERT INTO `ltqd_sports_teams` (`team_id`, `name`, `flag`, `league_id`, `update_hash`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, NOW(), NOW())");
								$addQuery->bind_param("issis", $thisTeam['id'],$thisTeam['name'],$thisTeam['flag'],$league['league_id'],$refreshHash);
								$addQuery->execute();
								$teamDbId = $addQuery->insert_id;
							}
							else
							{
								$resultArray = $teamResult->fetch_array();
								$teamDbId = $resultArray['id'];
								$updateQuery = $mysqli->prepare("UPDATE ltqd_sports_teams SET update_hash = ? WHERE team_id = ? AND league_id = ?");
								$updateQuery->bind_param("sii", $refreshHash,$thisTeam['id'],$league['league_id']);
								$updateQuery->execute();
							}
						}
					}
					$teamBId = $teamDbId;
				}
				if (!$result->num_rows) 
				{
					$addQuery = $mysqli->prepare("INSERT INTO `ltqd_sports_events` (`event_id`, `team_a_id`, `team_b_id`, `backdrop`, `start_timestamp`, `end_timestamp`, `description`, `created_at`, `updated_at`, `category_id`,  `league_id`, `update_hash`) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), ?, ?, ?)");
					$addQuery->bind_param("iiissssiis", $thisevent['id'],$teamAId,$teamBId,$thisevent['backdrop'],$thisevent['start_timestamp'],$thisevent['end_timestamp'],$thisevent['description'],$league['id'],$league['league_id'],$refreshHash);
					$addQuery->execute();
					$dbId = $addQuery->insert_id;
					//now add some channels
				}
				else
				{
					$resultArray = $result->fetch_array();
					$dbId = $resultArray['id'];
					$updateQuery = $mysqli->prepare("UPDATE ltqd_sports_events SET team_a_id = ?, team_b_id = ?, `start_timestamp` = ?, `end_timestamp` = ?, update_hash = ? WHERE event_id = ? AND league_id = ?");
					$updateQuery->bind_param("iisssii",$teamAId,$teamBId, $thisevent['start_timestamp'],$thisevent['end_timestamp'],$refreshHash,$thisevent['id'],$league['league_id']);
					$updateQuery->execute();
				}
				foreach($thisevent['channels'] as $channel)
				{
					$channelName = $mysqli->real_escape_string($channel['name']);
					$channelQuery = $mysqli->prepare("SELECT * FROM dns_channels WHERE trim(SUBSTRING_INDEX(SUBSTRING_INDEX(channel_name,'|',-1),':',-1))  LIKE '" . $channelName  . "%' OR channel_epg_name LIKE ?;");
					$channelQuery->bind_param("s", $channel['epg']);
					$channelQuery->execute();
					$channelResult = $channelQuery->get_result();
					while($thisChannel = $channelResult->fetch_array())
					{
						if(!checkDeleteLTQDEvent($dbId,$thisChannel['id']))
						{
							try
							{
							//add
							$addQuery = $mysqli->prepare("INSERT INTO `ltqd_sports_event_channels` (`event_id`, `channel_id`) VALUES (?, ?) ON DUPLICATE KEY UPDATE channel_id=channel_id;");
							$addQuery->bind_param("ii", $dbId,$thisChannel['id']);
							$addQuery->execute();
							} catch (Exception $e) {}
						}
					}
				}

				if($thisevent['team_a_name'])
				{
					$teamName = $mysqli->real_escape_string($thisevent['team_a_name']);
					$channelQuery = $mysqli->prepare("SELECT * FROM dns_channels WHERE trim(SUBSTRING_INDEX(SUBSTRING_INDEX(channel_name,'|',-1),':',-1))  LIKE '" . $teamName  . "%';");
					
					$channelQuery->execute();
					$channelResult = $channelQuery->get_result();
					while($thisChannel = $channelResult->fetch_array())
					{
						//add
							if(!checkDeleteLTQDEvent($dbId,$thisChannel['id']))
						{
							try
							{
						$addQuery = $mysqli->prepare("INSERT INTO `ltqd_sports_event_channels` (`event_id`, `channel_id`) VALUES (?, ?) ON DUPLICATE KEY UPDATE channel_id=channel_id");
						$addQuery->bind_param("ii", $dbId,$thisChannel['id']);
						$addQuery->execute();
						} catch (Exception $e) {}
						}
					}
				}
				if($thisevent['team_b_name'])
				{
										$teamName = $mysqli->real_escape_string($thisevent['team_b_name']);

					$channelQuery = $mysqli->prepare("SELECT * FROM dns_channels WHERE trim(SUBSTRING_INDEX(SUBSTRING_INDEX(channel_name,'|',-1),':',-1))  LIKE '" .  $teamName . "%';");
					
					$channelQuery->execute();
					$channelResult = $channelQuery->get_result();
					while($thisChannel = $channelResult->fetch_array())
					{
							if(!checkDeleteLTQDEvent($dbId,$thisChannel['id']))
						{
						//add
						try{
						$addQuery = $mysqli->prepare("INSERT INTO `ltqd_sports_event_channels` (`event_id`, `channel_id`) VALUES (?, ?) ON DUPLICATE KEY UPDATE channel_id=channel_id");
						$addQuery->bind_param("ii", $dbId,$thisChannel['id']);
						$addQuery->execute();
						} catch (Exception $e) {}
						}
					}
				}
				if($thisevent['team_a_name'] && $thisevent['team_b_name'])
				{
					$channelQuery = $mysqli->prepare("SELECT * FROM dns_channels WHERE channel_name LIKE '%" .  $thisevent['team_b_name'] . "%' AND channel_name LIKE '%" .  $thisevent['team_a_name'] . "%';");
					
					$channelQuery->execute();
					$channelResult = $channelQuery->get_result();
					while($thisChannel = $channelResult->fetch_array())
					{
						if(!checkDeleteLTQDEvent($dbId,$thisChannel['id']))
						{
							try
							{
							//add
							$addQuery = $mysqli->prepare("INSERT INTO `ltqd_sports_event_channels` (`event_id`, `channel_id`) VALUES (?, ?) ON DUPLICATE KEY UPDATE channel_id=channel_id");
							$addQuery->bind_param("ii", $dbId,$thisChannel['id']);
							$addQuery->execute(); 
							} catch (Exception $e) {}
						}
					}
				}
			}
			$updateQuery = $mysqli->prepare("DELETE FROM ltqd_sports_events WHERE league_id = ? AND update_hash != ?");
			$updateQuery->bind_param("is", $league['league_id'],$refreshHash);
			$updateQuery->execute();
		}
	}
}

function registerChat()
{
	global $sportsApiKey;
	$postdata = http_build_query(
    array(
			'webhook_url' => base64_encode($GLOBALS['panelroot'])
		)
	);

	$opts = array('http' =>
		array(
			'method'  => 'POST',
			'header'  => 'Content-Type: application/x-www-form-urlencoded',
			'content' => $postdata
		)
	);

	$context  = stream_context_create($opts);

	$regResponse = file_curl_contents("https://andyhax.uk/bot/register/" . $sportsApiKey,false,$context);
	$response = json_decode($regResponse,true);
	if($response['client_id'])
	{
		global $mysqli;
		$query = $mysqli->prepare("UPDATE ltqd_options SET chat_client_id = ?");
		$query->bind_param("i", $response['client_id']);
		$query->execute();
	}
	else
	{
		$_SESSION['chat_error'] = "Error registering your panel";
	}
}

function unregisterChat()
{
		global $sportsApiKey;
$ltqdOptions = loadLTQDOptions();

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://andyhax.uk/bot/unregister/' . $sportsApiKey . '/' . $ltqdOptions['chat_client_id'],
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET'
));

$response = curl_exec($curl);

curl_close($curl);


	global $mysqli;
	$query = $mysqli->prepare("UPDATE ltqd_options SET chat_client_id = NULL");
	$query->execute();
}

function getChatInfo($client_id)
{
	global $sportsApiKey;
	$regResponse = file_curl_contents("https://andyhax.uk/bot/check/" . $sportsApiKey . "/" . $client_id);
	$response = json_decode($regResponse,true);
	return $response['username'];
}

function pushChatNotification($username, $message)
{
	global $sportsApiKey;
$ltqdOptions = loadLTQDOptions();

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://andyhax.uk/bot/message/' . $sportsApiKey . '/' . $ltqdOptions['chat_client_id'],
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('user' => base64_encode($username),'message' => base64_encode($message)),
));

$response = curl_exec($curl);

curl_close($curl);

}

function file_curl_contents($url, $getHeaders = false)
{
	global $authVar;
	global $versionVar;
	 $ch = curl_init();

    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_URL, $url);
	$headers = [
		
		'User-Agent: OnePanel LTQD',
		'token-auth: ' . $authVar,
		'version-token: ' . $versionVar
	];
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($ch, CURLOPT_HEADER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	$response = curl_exec($ch);

	$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
	$header = substr($response, 0, $header_size);
	$html = substr($response, $header_size);

	$headers = get_headers_from_curl_response($header);
	if($getHeaders)
	{
		return ["data" => $html, "headers" => $headers];
	}
	else
	{
		return $html;
	}
   
}

function deleteEPG()
{
	$epgDir = "LTQD/epg-cache/";
	$files = scandir($epgDir);
	var_dump($files);
	foreach($files as $file)
	{
		if(is_file($epgDir .$file))
		{
			unlink ($epgDir .$file);
		}
	}
}

function deleteRemovedEvents()
{
	global $mysqli;
	$deleteQuery = $mysqli->prepare("DELETE FROM ltqd_sports_deleted_records");
	$deleteQuery->execute();
}

function deleteRemovedChannels()
{
	global $mysqli;
	$deleteQuery = $mysqli->prepare("DELETE FROM dns_categories WHERE dns_id NOT IN (SELECT id FROM dns)");
	$deleteQuery->execute();
	$deleteQuery = $mysqli->prepare("DELETE FROM dns_channels WHERE dns_id NOT IN (SELECT id FROM dns)");
	$deleteQuery->execute();
	$deleteQuery = $mysqli->prepare("DELETE FROM ltqd_sports_event_channels WHERE channel_id NOT IN (SELECT id FROM dns_channels)");
	$deleteQuery->execute();
}