<?php
session_start();
$dbFile = dirname(__file__) . "/includes/db.php";
include($dbFile);
if ($isInstalled && $dbIsLatest) {
  header("Location: index.php");
  exit;
}
if (isset($_POST['install'])) {
  session_destroy();
  session_start();
  $queryList = array();
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `ads` ( `id` int(11) NOT NULL AUTO_INCREMENT, `path` varchar(100) DEFAULT NULL, `active` tinyint(1) DEFAULT NULL, `name` varchar(100) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `dns` ( `id` int(11) NOT NULL AUTO_INCREMENT, `url` varchar(255) DEFAULT NULL, `active` tinyint(1) DEFAULT NULL, `name` varchar(100) DEFAULT NULL, `password` varchar(255) DEFAULT NULL, `username` varchar(255) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `dns_sessions` ( `id` int(11) NOT NULL AUTO_INCREMENT, `dns_id` int(11) DEFAULT NULL, `date_added` datetime DEFAULT NULL, `last_used` datetime DEFAULT NULL, `username` varchar(100) DEFAULT NULL, `password_hash` varchar(255) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `users` ( `id` int(11) NOT NULL AUTO_INCREMENT, `username` varchar(255) DEFAULT NULL, `password_hash` varchar(255) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `config` (`dbversion` int(11) DEFAULT NULL ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "INSERT INTO `config` VALUES (2);");
  $queryList[] = array('version' => 1, 'query' => "ALTER TABLE config ADD panel_root varchar(255) NULL;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE ltqd_options(id INTEGER PRIMARY KEY AUTO_INCREMENT, app_id VARCHAR(255), app_name VARCHAR(255), logo VARCHAR(255), intro_video VARCHAR(255), registration_link VARCHAR(255), version VARCHAR(255), enabled VARCHAR(255), force_update VARCHAR(255), created_at VARCHAR(255), updated_at VARCHAR(255), user_id VARCHAR(255), theme_id VARCHAR(255), welcome_message VARCHAR(255), apk_file VARCHAR(255), theme_download_url VARCHAR(255));");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE ltqd_appstore(id INTEGER PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255), package_name VARCHAR(255), install_url VARCHAR(255), description VARCHAR(255), banner VARCHAR(255), created_at VARCHAR(255), updated_at VARCHAR(255), app_id VARCHAR(255));");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE ltqd_sections(id INTEGER PRIMARY KEY AUTO_INCREMENT, title VARCHAR(255), enabled VARCHAR(255), predefined VARCHAR(255), reference INTEGER);");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE ltqd_section_items(id INTEGER PRIMARY KEY AUTO_INCREMENT, title VARCHAR(255), type VARCHAR(255), description VARCHAR(255), reference VARCHAR(255), backdrop_video VARCHAR(255), backdrop_image VARCHAR(255), order_no INTEGER, section_id INTEGER, created_at VARCHAR(255), updated_at VARCHAR(255));");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `ltqd_sports_teams` ( `id` int(11) NOT NULL AUTO_INCREMENT, `name` varchar(255) DEFAULT NULL, `flag` varchar(255) DEFAULT NULL, `created_at` varchar(255) DEFAULT NULL, `updated_at` varchar(255) DEFAULT NULL, `league_id` int(11) DEFAULT NULL, `team_id` int(11) DEFAULT NULL, `update_hash` varchar(100) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `ltqd_sports_events` ( `id` int(11) NOT NULL AUTO_INCREMENT, `team_a_id` int(11) DEFAULT NULL, `team_b_id` int(11) DEFAULT NULL, `backdrop` varchar(255) DEFAULT NULL, `start_timestamp` varchar(255) DEFAULT NULL, `end_timestamp` varchar(255) DEFAULT NULL, `description` varchar(255) DEFAULT NULL, `created_at` varchar(255) DEFAULT NULL, `updated_at` varchar(255) DEFAULT NULL, `category_id` int(11) DEFAULT NULL, `channel_id` varchar(255) DEFAULT NULL, `league_id` int(11) DEFAULT NULL, `update_hash` varchar(100) DEFAULT NULL, `event_id` int(11) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE ltqd_themes(id INTEGER PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255), preview_image VARCHAR(255), created_at VARCHAR(255), updated_at VARCHAR(255), download_url VARCHAR(255));");
  $queryList[] = array('version' => 1, 'query' => "INSERT INTO ltqd_options (id, app_id, app_name, logo, intro_video, registration_link, version, enabled, force_update, created_at, updated_at, user_id, theme_id, welcome_message, apk_file, theme_download_url) VALUES(1, 'com.qdeluxe.app', 'LTQ Deluxe', 'https://i.imgur.com/ceVw1FV.png', '', '', '1671343019', '1', '0', '2020-06-14 09:53:09', '2023-01-01 13:40:05', '1', '-1', 'Welcome to LTQ Deluxe', '', '');");
  $queryList[] = array('version' => 1, 'query' => "INSERT INTO ltqd_sections (id, title, enabled, predefined, reference) VALUES(1, 'Recent Movies', '1', 'recent-movies', 0);");
  $queryList[] = array('version' => 1, 'query' => "INSERT INTO ltqd_sections (id, title, enabled, predefined, reference) VALUES(2, 'Recent Shows', '1', 'recent-shows', 0);");
  $queryList[] = array('version' => 1, 'query' => "INSERT INTO ltqd_themes (id, name, preview_image, created_at, updated_at, download_url) VALUES(1, 'Glass', 'https://qd.cms-login-1222722.com/storage/uploads/files/158/themes/Sky%20Glass.png', '2023-01-01 00:00:00', '2023-01-01 00:00:00', 'https://api-02.io/themes/download/575');");
  $queryList[] = array('version' => 1, 'query' => "INSERT INTO ltqd_appstore (id, name, package_name, install_url, description, banner, created_at, updated_at, app_id) VALUES(1, 'VLC Player', 'org.videolan.vlc', 'https://play.google.com/store/apps/details?id=org.videolan.vlc&hl=en', 'VLC media player is a free and open source cross-platform multimedia player that plays most multimedia files as well as discs, devices, and network streaming protocols.', 'https://qd.cms-login-1222722.com/storage/uploads/files/136/news/vlc%20player.png', '2023-01-01 00:00:00', '2023-01-01 00:00:00', '1');");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `dns_categories` ( `id` int(11) NOT NULL AUTO_INCREMENT, `dns_id` int(11) DEFAULT NULL, `category_ref` int(11) DEFAULT NULL, `category_name` varchar(100) DEFAULT NULL, `refresh_hash` varchar(100) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `dns_channels` ( `id` int(11) NOT NULL AUTO_INCREMENT, `category_id` int(11) DEFAULT NULL, `channel_name` varchar(255) DEFAULT NULL, `channel_number` int(11) DEFAULT NULL, `channel_epg_name` varchar(255) DEFAULT NULL, `refresh_hash` varchar(100) DEFAULT NULL, `dns_id` int(11) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `ltqd_sports_event_channels` ( `event_id` int(11) NOT NULL, `channel_id` int(11) NOT NULL, PRIMARY KEY (`event_id`,`channel_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `ltqd_sports_categories` ( `id` int(11) NOT NULL AUTO_INCREMENT, `title` varchar(255) DEFAULT NULL,`league_id` varchar(100) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 1, 'query' => "CREATE TABLE `ltqd_channel_reports` ( `id` int(11) NOT NULL AUTO_INCREMENT, `username` varchar(255) DEFAULT NULL, `message` varchar(255) DEFAULT NULL, `type` varchar(100) DEFAULT NULL, `stream_id` int(11) DEFAULT NULL, `dns` varchar(255) DEFAULT NULL, `report_date` datetime DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 8, 'query' => "ALTER TABLE ltqd_sections ADD order_no int NULL;");
  $queryList[] = array('version' => 8, 'query' => "UPDATE ltqd_sections SET order_no = id");
  $queryList[] = array('version' => 9, 'query' => "CREATE TABLE `ltqd_messages` ( `id` int(11) NOT NULL AUTO_INCREMENT, `message_text` text, `username` varchar(100) DEFAULT NULL, `message_datetime` int(11) DEFAULT NULL, `message_outbound` tinyint(4) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 9, 'query' => "ALTER TABLE ltqd_options ADD message_from varchar(255) NULL;");
  $queryList[] = array('version' => 9, 'query' => "ALTER TABLE ltqd_options ADD message_autorespond TEXT NULL;");
  $queryList[] = array('version' => 9, 'query' => "UPDATE ltqd_options SET message_from = 'Admin'");
  $queryList[] = array('version' => 9, 'query' => "CREATE TABLE `ltqd_sports_deleted_records` ( `id` int(11) NOT NULL AUTO_INCREMENT, `event_id` int(11) DEFAULT NULL, `channel_id` int(11) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 11, 'query' => "ALTER TABLE ltqd_options ADD chat_client_id int NULL;");
  $queryList[] = array('version' => 12, 'query' => "CREATE TABLE `movie_categories` ( `id` int(11) NOT NULL AUTO_INCREMENT, `dns_id` int(11) DEFAULT NULL, `ref` int(11) DEFAULT NULL, `name` varchar(255) DEFAULT NULL, `refresh_hash` varchar(100) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 12, 'query' => "CREATE TABLE `movie_streams` ( `id` int(11) NOT NULL AUTO_INCREMENT, `category_id` int(11) DEFAULT NULL, `name` varchar(255) DEFAULT NULL, `stream_id` int(11) DEFAULT NULL, `refresh_hash` varchar(100) DEFAULT NULL, `dns_id` int(11) DEFAULT NULL, PRIMARY KEY (`id`), KEY `movie_streams_dns_id_IDX` (`dns_id`,`stream_id`) USING BTREE ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 12, 'query' => "CREATE TABLE `tv_categories` ( `id` int(11) NOT NULL AUTO_INCREMENT, `dns_id` int(11) DEFAULT NULL, `ref` int(11) DEFAULT NULL, `name` varchar(255) DEFAULT NULL, `refresh_hash` varchar(100) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 12, 'query' => "CREATE TABLE `tv_series` ( `id` int(11) NOT NULL AUTO_INCREMENT, `category_id` int(11) DEFAULT NULL, `name` varchar(255) DEFAULT NULL, `series_id` int(11) DEFAULT NULL, `refresh_hash` varchar(100) DEFAULT NULL, `dns_id` int(11) DEFAULT NULL, PRIMARY KEY (`id`), KEY `tv_series_dns_id_IDX` (`dns_id`,`series_id`) USING BTREE ) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;");
  $queryList[] = array('version' => 13, 'query' => "CREATE INDEX dns_channels_channel_number_IDX USING BTREE ON dns_channels (channel_number,dns_id);");
  
  $queryList[] = array('version' => 100000, 'query' => "UPDATE config SET dbversion = " . $expectedVersion . ";");
  $randPass = randomPassword();
  $hash = password_hash($randPass, PASSWORD_DEFAULT);
  $queryList[] = array('version' => 1, 'query' => "INSERT INTO `users` (username, password_hash) VALUES ('admin', '" . $hash  . "');");
  if (!$isInstalled) {
	$it = new RecursiveDirectoryIterator("LTQD/theme-files/");
	$display = Array ( 'qth' );
	foreach(new RecursiveIteratorIterator($it) as $file)
	{
		if (in_array(strtolower(array_pop(explode('.',$file ))), $display))
		{
			$path_parts = pathinfo($file);
			$themeName = $path_parts['filename']; 
			$url =  $GLOBALS['panelroot'] .  $file;
			
			$jpgPath = str_replace(".qth",".jpg",$file);
			$jpegPath = str_replace(".qth",".jpeg",$file);
			$pngPath = str_replace(".qth",".png",$file);
			if(file_exists($jpgPath))
			{
				$imageUrl = $_POST['onepanel_root'] . $jpgPath;
			} else if(file_exists($jpegPath))
			{
				$imageUrl = $_POST['onepanel_root'] . $jpegPath;
			}
			else if(file_exists($pngPath))
			{
				$imageUrl = $_POST['onepanel_root'] . $pngPath;
			}
			$data = array();
			$data['name'] = $themeName;
			$data['preview_image'] = $imageUrl;
			$data['download_url'] = $url;
			$data['created_at'] = date('Y-m-d H:i:s');
			$data['updated_at'] = date('Y-m-d H:i:s');
			addDbEntry("ltqd_themes", $data);
		}
	}
    $_SESSION['installmessage'] = "OnePanel has been installed. You can log in with the username <b>admin</b> and the password <b>" . $randPass . "</b><br/>Please make a note of this password now as it will disappear if the page is refreshed. You should change this once logged in";
  } else {
    $_SESSION['installmessage'] = "OnePanel has been updated";
  }
  //execute queries
  foreach ($queryList as $query) {
    if ($query['version'] > $insVersion) {
      $mysqli->query($query['query']);
    }
  }
  $query = $mysqli->prepare("UPDATE config SET panel_root = ?");
  $query->bind_param("s", $_POST['onepanel_root']);
  $query->execute();
  
  
  header("Location: index.php");
  exit;
}
function randomPassword()
{
  $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
  $pass = array();
  $alphaLength = strlen($alphabet) - 1;
  for ($i = 0; $i < 10; $i++) {
    $n = rand(0, $alphaLength);
    $pass[] = $alphabet[$n];
  }
  return implode($pass);
}
$showButton = false;
if ($dbConnected) {
	 if (!$isInstalled) {
		$headerText = "Install";
		$message = "OnePanel is ready to install to database <b>$dbname</b>, click GO to build the database";
	 }
	 else
	 {
		$headerText = "Upgrade";
		$message = "OnePanel is ready to upgrade database <b>$dbname</b>, click GO to update the database. Your existing data will <b>not</b> be lost.";
	 }
	 $showButton = true;
} else {
  $message = "OnePanel cannot connect to the database, please create an empty database and edit the <b>includes/db.php</b> file with the details, then refresh this page.";
}
?>
<!--
=========================================================
* Material Dashboard 2 - v3.0.4
=========================================================

* Product Page: https://www.creative-tim.com/product/material-dashboard
* Copyright 2022 Creative Tim (https://www.creative-tim.com)
* Licensed under MIT (https://www.creative-tim.com/license)
* Coded by Creative Tim

=========================================================

* The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
-->
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="apple-touch-icon" sizes="180x180" href="assets/fav/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/fav/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/fav/favicon-16x16.png">
  <link rel="manifest" href="site.webmanifest">
  <link rel="mask-icon" href="assets/fav/safari-pinned-tab.svg" color="#5bbad5">
  <meta name="msapplication-TileColor" content="#da532c">
  <meta name="theme-color" content="#ffffff">
  <title>
    OnePanel
  </title>
  <!--     Fonts and icons     -->
  <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900|Roboto+Slab:400,700" />
  <!-- Nucleo Icons -->
  <link href="assets/css/nucleo-icons.css" rel="stylesheet" />
  <link href="assets/css/nucleo-svg.css" rel="stylesheet" />
  <!-- Font Awesome Icons -->
  <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
  <!-- Material Icons -->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Round" rel="stylesheet">
  <!-- CSS Files -->
  <link id="pagestyle" href="assets/css/material-dashboard.min.css?v=3.0.4" rel="stylesheet" />
</head>

<body class="bg-gray-200">
  <main class="main-content  mt-0">
    <div class="page-header align-items-start min-vh-100" style="background-image: url('assets/img/bg.jpg');">
      <span class="mask bg-gradient-dark opacity-6"></span>
      <div class="container my-auto">
        <div class="row">
          <div class="col-lg-4 col-md-8 col-12 mx-auto">
            <div class="card z-index-0 fadeIn3 fadeInBottom">
              <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-secondary shadow-dark border-radius-lg py-3 pe-1">
                  <h4 class="text-white font-weight-bolder text-center mt-2 mb-0"><?php echo $headerText; ?></h4>
                </div>
              </div>
              <div class="card-body">
                <form action="" method="post" role="form" class="text-start">
                  <p class="mt-4 text-sm text-center">
                    <?php echo $message; ?>
                  </p>

                  <input type="hidden" id="onepanel_root" name="onepanel_root" class="form-control">
                  <?php
                  if ($showButton) {
                  ?>
                    <div class="text-center">
                      <button type="submit" name="install" type="button" class="btn bg-gradient-secondary w-100 my-4 mb-2">Go</button>
                    </div>
                  <?php
                  }
                  ?>

                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <footer class="footer position-absolute bottom-2 py-2 w-100">
        <div class="container">
          <div class="row align-items-center justify-content-lg-between">
            <div class="col-12 col-md-6 my-auto">
              <div class="copyright text-center text-sm text-white text-lg-start">
                © <script>
                  document.write(new Date().getFullYear())
                </script>,
                G-SAT Media
              </div>
            </div>

          </div>
        </div>
      </footer>
    </div>
  </main>
  <!--   Core JS Files   -->
  <script src="assets/js/core/popper.min.js"></script>
  <script src="assets/js/core/bootstrap.min.js"></script>
  <script src="assets/js/plugins/perfect-scrollbar.min.js"></script>
  <script src="assets/js/plugins/smooth-scrollbar.min.js"></script>
  <script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
      var options = {
        damping: '0.5'
      }
      Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
  </script>
  <!-- Github buttons -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <!-- Control Center for Material Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="assets/js/material-dashboard.min.js?v=3.0.4"></script>
</body>
<script>
  var href = window.location.href;
  var dir = href.substring(0, href.lastIndexOf('/')) + "/";
  document.getElementById("onepanel_root").value = dir;
</script>

</html>